
# parent class used to specify interface
class Optimizer(object):
    # intializes the optimizer with its required data
    # return type: self
    def __init__(self,number_top_states,characterizer,verbose=False):
        self.verbose = verbose
        self.number_top_states = number_top_states
        self.characterizer = characterizer
        self.top_states = [-1 for state in range(number_top_states)]
        self.top_values = [float("-inf") for state in range(number_top_states)]

        # dictionary storing the state and evaluated value of every state
        self.explored_states = {}

    # ABSTRACT:determines whether algorithm should proceed with next batch of states
    # returns type: bool
    def isFinished(self):
        raise Exception("Optimizer isFinished is not defined")

    # ABSTRACT: provides the next batch of states to be measured
    # if there IS a sort of batch counter checked by is finished, it is updated here
    # returns type: list of states
    def getNextStates(self):
        raise Exception("Optimizer getNextStates is not defined")

    # characterize each of the states explored compared to the baseline_state
    # store characterization value in a dictionary
    # update the list of top states
    def evaluateMeasurements(self,states,baseline_state):
        if self.verbose:
            print "Evaluating measurements"
        for state in states:
            state_value = self.characterizer.characterize(state,baseline_state)
            self.explored_states[state] = state_value
            self.compareWithOptimalList(state,state_value)

    # maintains a list of top states by comparing new state with optimals
    # returns type: None
    def compareWithOptimalList(self, state, value):
        if state >= 0:
            optimal_idx = self.number_top_states - 1
            larger_value = False
            while not larger_value:
                stored_value = self.top_values[optimal_idx]
                stored_state = self.top_states[optimal_idx]
                if value >= stored_value:
                    self.top_values[optimal_idx] = value
                    self.top_states[optimal_idx] = state
                    if optimal_idx + 1 < self.number_top_states:
                        self.top_values[optimal_idx+1] = stored_value
                        self.top_states[optimal_idx+1] = stored_state
                else:
                    larger_value = True
                optimal_idx = optimal_idx - 1
                if optimal_idx < 0:
                    larger_value = True

    # returns the optimal state from the optimizer
    # returns type: state
    def getOptimalState(self):
        optimum_state = self.top_states[0]
        optimum_value = self.top_values[0]
        if self.verbose:
            print "Optimal State:", optimum_state,", Value =", optimum_value
        return optimum_state

    # returns the list of  optimal states
    # returns type: [state]
    def getOptimalList(self):
        return self.top_states
